## Master script for data and parameters in model

### This script runs all scripts required to generate the model parameters, in the correct order


# Master package loading ----------------------------------------------------------

source("./R scripts/Master package loading.R", encoding="ISO-8859-1")


# Master HILDA data set up -------------------------------------------------------

## Pulls original HILDA data and related files into desired format
## No need to run each time unless underlying HILDA data is updated

# source("./R scripts/1 - Master HILDA data set up/Read and format HILDA.R")
# source("./R scripts/1 - Master HILDA data set up/Read HILDA first estate bequest.R")
# source("./R scripts/1 - Master HILDA data set up/Read HILDA indiv wealth.R")
# source("./R scripts/1 - Master HILDA data set up/Read HILDA longitudinal weights.R")


# Master HILDA grouped ----------------------------------------------------

## One consistent HILDA dataset which includes all HILDA data for all waves used in other scripts, including grouping variables.
source("./R scripts/Data and parameters/HILDA grouped.R")



# Model starting values ---------------------------------------------------

## 2018 cohort data for model use
source("./R scripts/Data and parameters/HILDA starting values by cohort.R")



# Mortality and bequest receipt -------------------------------------------

## Probability of dying
source("./R scripts/Data and parameters/Mortality rates.R")

## Probability of cohort parents dying
source("./R scripts/Data and parameters/Bequest receipt probability.R")



# Income, tax and super projections ------------------------------------------------------

## Income projections
source("./R scripts/Data and parameters/Income projections.R")

## Add tax and super projections
source("./R scripts/Data and parameters/Income tax and super contributions.R")



# Housing accumulation ---------------------------------------------------------

## Generates all housing parameters, including transition probabilities and values
source("./R scripts/Data and parameters/Housing accumulation.R")



# Other asset accumulation ------------------------------------------------

## Rates of return in other assets
source("./R scripts/Data and parameters/Returns in other assets.R")

## Saving in other assets
source("./R scripts/Data and parameters/Saving in other assets.R")

## Drawdowns in other assets
source("./R scripts/Data and parameters/Drawdowns in other assets.R")



# Wealth accum parameters -------------------------------------------------

## Combine all wealth accum parameters
source("./R scripts/Data and parameters/Wealth accumulation parameters.R")



# Standalone parameters - inc transitions, gifting rates, partnered status, bequest pool dist ---------------------------------------------------

## Income transitions - takes a while to run
source("./R scripts/Data and parameters/Income transitions.R")

## Gifting rates
source("./R scripts/Data and parameters/Gifting rates.R")

## Partnered status
source("./R scripts/Data and parameters/Partnered status at death by age ABS.R")

## Bequest pool distribution
source("./R scripts/Data and parameters/Bequest pool distribution.R")